;__CUBPRPC_________________________________________________________________________________________
;
;	PREP THE IDE DRIVE (DRIVE "C") FOR CUBIX
;
;	WRITTEN BY: DAN WERNER -- 12/8/2009
;__________________________________________________________________________________________________
;__________________________________________________________________________________________________
;
; CONFIGURATION
;__________________________________________________________________________________________________
;
;
IDEOFFSET	.EQU	$50		; SET FOR STARTING OF IDE PARTITION
					; PARTITION SIZE IS $FFFF SECTORS (32MB), AND LBA ADDRESS
					; WILL BE OOXXXX, WHERE OO IS OFFSET AND XXXX ARE SECTORS
					; 0000-FFFF.
USEDSKY		.EQU	01		; NONZERO = USE DSKY DEVICE FOR DISK IO STATUS
				
;
;
;__________________________________________________________________________________________________
;
; DATA CONSTANTS
;__________________________________________________________________________________________________
;REGISTER		IO PORT		; FUNCTION
PPIA		.equ	$00		; 8255 PORT A
PPIB		.equ	$01		; 8255 PORT B
PPIC		.equ	$02		; 8255 PORT C
PPICONT		.equ	$03		; 8255 CONTROL PORT 

BDOS		.equ	$0005		; BDOS ENTRY

; IDE REGISTER		IO PORT		; FUNCTION
IDELO:		 .EQU 	20H		; DATA PORT (LOW BYTE)
IDEERR:		 .EQU 	21H		; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC:	 .EQU 	22H		; SECTOR COUNT
IDESECTN:	 .EQU 	23H		; SECTOR NUMBER
IDECYLLO:	 .EQU 	24H		; CYLINDER LOW
IDECYLHI:	 .EQU 	25H		; CYLINDER HIGH
IDEHEAD:	 .EQU 	26H		; DRIVE/HEAD
IDESTTS:	 .EQU 	27H		; READ: STATUS; WRITE: COMMAND
IDEHI:		 .EQU 	28H		; DATA PORT (HIGH BYTE)
IDECTRL:	 .EQU 	2EH		; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR:	 .EQU 	2FH		; DRIVE ADDRESS (READ ONLY)
CR		.EQU	$0D		; CARRIAGE RETURN CHARACTER
LF		.EQU	$0A		; LINE FEED CHARACTER
END		.EQU	'$'		; LINE TERMINATOR FOR CP/M STRINGS



	.org	$0100


;__________________________________________________________________________________________________
;
; 	MAIN 
;__________________________________________________________________________________________________
MAIN:
					; BLANK OUT FIRST 257 SECTORS
	LD	HL,SECTOR_BUFFER	;
	LD	BC,$0200		;
	LD	A,$00			;
	CALL	FILL_MEM		;
	
	LD	A,$00			;
	LD	(SECTOR),A		;
	LD	(HEAD),A		;
	LD	A,$01			;
	LD	(TRACK),A		;
	CALL	WRITE_2			;
	
	LD	A,$00			;
	LD	(SECTOR),A		;
	LD	(HEAD),A		;
	LD	(TRACK),A		;
MAIN_1:
	CALL	WRITE_2			;
	LD	A,(SECTOR)		;
	ADD	A,1			;
	LD	(SECTOR),A		;
	JP	NZ,MAIN_1		;

	LD	HL,SECTOR_BUFFER	;
	LD	BC,$0000		;	
MAIN_2:
	INC	BC			;
	LD	(HL),B			;
	INC	HL			;
	LD	(HL),C			;
	INC	HL			;
	LD	A,B			;
	CP	$02			;
	JP	NZ,MAIN_2		;
	
	LD	A,$0FF			;
	LD	(SECTOR_BUFFER),A	;
	LD	(SECTOR_BUFFER+1),A	;
	LD	A,$01			;
	LD	(SECTOR),A		;
	LD	A,$00			;
	LD	(HEAD),A		;
	LD	(TRACK),A		;
	CALL	WRITE_2			;
	
	LD	HL,SECTOR_BUFFER	;
	LD	BC,$0200		;
	LD	A,$00			;
	CALL	FILL_MEM		;

	LD	A,$0FF			;
	LD	(SECTOR_BUFFER),A	;
	LD	(SECTOR_BUFFER+1),A	;
	LD	A,$02			;
	LD	(SECTOR),A		;
	LD	A,$00			;
	LD	(HEAD),A		;
	LD	(TRACK),A		;
	CALL	WRITE_2			;

	
	LD	DE,MSG_END		;
	LD	C,09H			; CP/M WRITE END STRING TO CONSOLE CALL
	CALL	0005H			;
					;
	LD	C,00H			; CP/M SYSTEM RESET CALL
	CALL	0005H			; RETURN TO PROMPT

MSG_END:
	.DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	.TEXT	"END CUBIX IDE PREP PROGRAM"
	.DB	LF, CR			; LINE FEED AND CARRIAGE RETURN
	.DB	END			; LINE TERMINATOR

	
	
	
	
	
	
	


	
	

;__WRITE_2__________________________________________________________________________________________ 
;
;	WRITE A SECTOR TO DRIVE 2
;___________________________________________________________________________________________________
;
WRITE_2:
					;
	LD	A,(SECTOR)		;
	LD	(LBA_TARGET_LO),A 	; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	A,(TRACK)		;
	LD	(LBA_TARGET_LO+1),A	; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	A,(HEAD)		;
	
	ADD	A,IDEOFFSET		; OFFSET CP/M PARTITION
	
	LD	(LBA_TARGET_HI),A 	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	A,00H			;
	LD	(LBA_TARGET_HI+1),A	; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
						
	CALL	IDE_WRITE_SECTOR	; WRITE THE IDE HARD DISK SECTOR
	RET

	
	
;__FILL_MEM______________________________________________________________________________________________________________________ 
;
;	Function	: fill memory with a value
;      	Input		: HL = start address block
;			: BC = length of block
;			: A = value to fill with
;	Uses		: DE, BC
;________________________________________________________________________________________________________________________________
;

FILL_MEM:

					; HL = start address of block
					; DE = HL + 1
	ld	e,l			;
	ld	d,h			;
	inc	de			;
					; initialise first byte of block
					; with data byte (&00)
					; with data byte in A
	ld	(hl),A			;
	ldir				;
	RET				; return to caller
	
	
	
		
;___IDE_READ_SECTOR______________________________________________________________________________________
;
;	READ IDE SECTOR
;________________________________________________________________________________________________________			
IDE_READ_SECTOR:
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
	LD	A,20H			;
	OUT	(IDESTTS),A		; 020h = IDE 'READ SECTOR' COMMAND 
IDE_SREX:				;
	CALL	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_BUFFER		; WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
	RET	NC			; ERROR, RETURN
	CALL	IDE_READ_BUFFER		; GRAB THE 256 WORDS FROM THE BUFFER
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET
	
;___IDE_WRITE_SECTOR_____________________________________________________________________________________
;
;	WRITE IDE SECTOR
;________________________________________________________________________________________________________			
IDE_WRITE_SECTOR:
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
	LD	A,30H			;
	OUT	(IDESTTS),A		; 030h = IDE 'WRITE SECTOR' COMMAND 
	CALL	IDE_WAIT_BUSY_READY	;
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	CALL	IDE_WAIT_BUFFER		; WAIT FOR BUFFER READY SIGNAL FROM DRIVE
	RET	NC			; ERROR, RETURN
	CALL	IDE_WRITE_BUFFER 	; SEND 256 WORDS TO DRIVE'S BUFFER
	CALL	IDE_WAIT_BUSY_READY 	; MAKE SURE DRIVE IS READY TO PROCEED
	RET	NC			; ERROR, RETURN
	CALL	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
	RET	NC			; ERROR, RETURN
	SCF				; CARRY = 1 ON RETURN = OPERATION OK
	RET		

;___IDE_SOFT_RESET_______________________________________________________________________________________
;
;	RESET IDE CHANNEL
;________________________________________________________________________________________________________			
IDE_SOFT_RESET:
	LD	A,000000110b		; NO INTERRUPTS, RESET DRIVE = 1
	OUT	(IDECTRL),A		;
	LD	A,000000010b		; NO INTERRUPTS, RESET DRIVE = 0
	OUT	(IDECTRL),A		;
	CALL	IDE_WAIT_BUSY_READY	;THIS TAKES A COUPLE OF SECONDS
	RET	

	
;___IDE_WAIT_DRQ_READY___________________________________________________________________________________
;
;	WAIT FOR IDE CHANNEL TO BE READY
;________________________________________________________________________________________________________			
IDE_WAIT_DRQ_READY:
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	000001000b		; MASK OFF RDY BIT
	JR	Z,IDE_WAIT_DRQ_READY	; WE WANT DRQ(3) TO BE 1
	RET

;___IDE_WAIT_DRQ_ZERO____________________________________________________________________________________
;
;	WAIT FOR IDE DRQ TO BE ZERO
;________________________________________________________________________________________________________			
IDE_WAIT_DRQ_ZERO:
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	000001000b		; MASK OFF RDY BIT
	JR	NZ,IDE_WAIT_DRQ_ZERO	; WE WANT DRQ(3) TO BE 0
	RET

;___IDE_WAIT_BUSY_READY___________________________________________________________________________________
;
;	WAIT FOR IDE CHANNEL TO BE READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUSY_READY:
	LD	DE,0			; CLEAR DE
IDE_WBSY:				;
	LD	B,5			; SETUP TIMEOUT
IDE_DLP:				;
	DEC	B			;
	JP	NZ,IDE_DLP		;
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO		;
	IN	A,(IDESTTS)		; READ ERROR REG
	AND	011000000b		; MASK OFF BUSY AND RDY BITS
	XOR	001000000b		; WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1
	JP	NZ,IDE_WBSY		;
	SCF				; CARRY 1 = OK
	RET
IDE_TO:
	XOR	A			; CARRY 0 = TIMED OUT
	RET
	
;___IDE_TEST_ERROR_______________________________________________________________________________________
;
;	CHECK FOR IDE ERROR CONDITION
;________________________________________________________________________________________________________			
IDE_TEST_ERROR:
	SCF				;
	IN	A,(IDESTTS)		;
	LD	B,A			; 
	AND	000000001b		; TEST ERROR BIT
	SCF				; 
	RET	Z			;
	LD	A,B			; 
	AND	000100000b		;
	SCF				;
	JP	NZ,IDE_ERR		; TEST WRITE ERROR BIT
	IN	A,(IDEERR)		; READ ERROR FLAGS
IDE_ERR:
	OR	A			; CARRY 0 = ERROR
	RET				; IF A = 0, IDE BUSY TIMED OUT

;___IDE_WAIT_BUFFER_______________________________________________________________________________________
;
;	WAIT FOR DATA BUFFER READY
;________________________________________________________________________________________________________			
IDE_WAIT_BUFFER:
	LD	DE,0			;
IDE_WDRQ:				;
	LD	B,5			;
IDE_BLP:				;
	DEC	B			;
	JP	NZ,IDE_BLP		;	
	INC	DE			;
	LD	A,D			;
	OR	E			;
	JP	Z,IDE_TO2		;
	IN	A,(IDESTTS)		; WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
	AND	000001000b		; TO FILL (OR READY TO FILL)
	JP	Z,IDE_WDRQ		;
	SCF				; CARRY 1 = OK
	RET				;
IDE_TO2:				;
	XOR	A			; CARRY 0 = TIMED OUT
	RET				;

;___IDE_READ_BUFFER_______________________________________________________________________________________
;
;	READ IDE BUFFER
;________________________________________________________________________________________________________			
IDE_READ_BUFFER:
	PUSH	HL			;
	LD	HL,SECTOR_BUFFER	;
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFRD:				;
	IN	A,(IDELO)		; LOW BYTE OF WORD FIRST	
	LD	(HL),A			;
	IN	A,(IDEHI)		; THEN HIGH BYTE OF WORD
	INC	HL			;
	LD	(HL),A			;
	INC	HL			;
	DEC	B			;
	JP	NZ,IDEBUFRD		;
	POP	HL			;
	RET

;___IDE_WRITE_BUFFER_______________________________________________________________________________________
;
;	WRITE TO IDE BUFFER
;________________________________________________________________________________________________________			
IDE_WRITE_BUFFER:
	PUSH	HL			;
	LD	HL,SECTOR_BUFFER	;
	LD	B,0			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFWT:				;
	INC	HL			;
	LD	A,(HL)			;
	DEC	HL			;
	OUT	(IDEHI),A		; SET UP HIGH LATCHED BYTE BEFORE
	LD	A,(HL)			;
	OUT	(IDELO),A		; WRITING WORD WITH WRITE TO LOW BYTE
	INC	HL			;
	INC	HL			;
	DEC	B			;
	JP	NZ,IDEBUFWT		;
	POP	HL			;
	RET		
	
;___IDE_SETUP_LDA________________________________________________________________________________________
;
;	SETUP IDE DRIVE FOR LDA OPERATION
;________________________________________________________________________________________________________			
IDE_SETUP_LBA:
	LD	A,(LBA_TARGET_LO) 	; LOAD LBA REGISTER 0 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA0),A		;
	LD	A,(LBA_TARGET_LO+1)	; LOAD LBA REGISTER 1 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA1),A		;
	LD	A,(LBA_TARGET_HI) 	; LOAD LBA REGISTER 2 WITH SECTOR ADDRESS TO READ
	LD	(IDE_LBA2),A		;
	LD	A,(LBA_TARGET_HI+1)	; LOAD LBA REGISTER 3 WITH SECTOR ADDRESS TO READ
	AND	000001111b		; ONLY LOWER FOUR BITS ARE VALID
	ADD	A,011100000b		; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	LD	(IDE_LBA3),A		;
					; READ IDE HD SECTOR
	LD	A,1			;
	OUT	(IDESECTC),A		; SET SECTOR COUNT = 1	
					;	
	LD	A,(IDE_LBA0)		;
	OUT	(IDESECTN),A		; SET LBA 0:7
					;
	LD	A,(IDE_LBA1)		;
	OUT	(IDECYLLO),A		; SET LBA 8:15
					;
	LD	A,(IDE_LBA2)		;
	OUT	(IDECYLHI),A		; SET LBA 16:23
					;
	LD	A,(IDE_LBA3)		;
	AND	000001111b		; LOWEST 4 BITS USED ONLY
	OR	011100000b		; TO ENABLE LBA MODE
	OUT	(IDEHEAD),A		; SET LBA 24:27 + BITS 5:7=111
	.IF	USEDSKY
	CALL	IDESEGDISPLAY		;
	.ENDIF
	RET	

	
	
;__DELAY24__________________________________________________________________________________________________________________________ 
;
; 	DELAY 24US
;________________________________________________________________________________________________________________________________
;
	
DELAY24:	
					; JP= 10T	
	PUSH	IX			; 15T
	POP	IX			; 14T
	PUSH	IX			; 15T
	POP	IX			; 14T
DELAY12:
	PUSH	IX			; 15T
	POP	IX			; 14T
	RET				; 10T


	

;__DELAYHSEC__________________________________________________________________________________________________________________________ 
;
; DELAY FOR 1/2 SECOND
;________________________________________________________________________________________________________________________________
;		
DELAYHSEC:
	LD	HL,00000H		; 65536
DELDM:
	NOP				; (4 T) 
	NOP				; (4 T)
	NOP				; (4 T)
	NOP				; (4 T)
	DEC	L			; (6 T)
	JP	NZ,DELDM		; (10 T) 24 T  8 MICROSECONDS AT 4 MHZ
	DEC	H			; (6 T)
	JP	NZ,DELDM		; (10 T) (8 US * 256) * 256  524288 US   5 SECONDS
	RET

	

; PIO 82C55 I/O IS DECODED TO PORT 60-67
;
PORTA		 .EQU 	60H
PORTB		 .EQU 	61H
PORTC		 .EQU 	62H
PIOCONT 	 .EQU 	63H	

;__IDESEGDISPLAY________________________________________________________________________________________
;
;  DISPLAY CONTENTS OF IDE LOGICAL BLOCK ADDRESS ON DSKY    
;____________________________________________________________________________________________________
IDESEGDISPLAY:
	LD	A, 82H			;
	OUT (PIOCONT),A			;
					;
	LD	A,(IDE_LBA3)		;
	AND	0FH			;
	LD	(DISPLAYBUF+6),A	;
	LD	A,(IDE_LBA3)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+7),A	;
					;
	LD	A,(IDE_LBA2)		;
	AND	0FH			;
	LD	(DISPLAYBUF+4),A	;
	LD	A,(IDE_LBA2)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+5),A	;
					;
	LD	A,(IDE_LBA1)		;
	AND	0FH			;
	LD	(DISPLAYBUF+2),A	;
	LD	A,(IDE_LBA1)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+3),A	;
	
	LD	A,(IDE_LBA0)		;
	AND	0FH			;
	LD	(DISPLAYBUF),A		;
	LD	A,(IDE_LBA0)		;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+1),A	;
	JP	SEGDISPLAY1		;
;__ATAPISEGDISPLAY________________________________________________________________________________________
;
;  DISPLAY CONTENTS OF ATAPI LOGICAL BLOCK ADDRESS ON DSKY    
;____________________________________________________________________________________________________
ATAPISEGDISPLAY:
	LD	A, 82H			;
	OUT (PIOCONT),A			;
					;
	LD	A,(LBA_TARGET_HI+1)	;
	AND	0FH			;
	LD	(DISPLAYBUF+6),A	;
	LD	A,(LBA_TARGET_HI+1)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+7),A	;
					;
	LD	A,(LBA_TARGET_HI)	;
	AND	0FH			;
	LD	(DISPLAYBUF+4),A	;
	LD	A,(LBA_TARGET_HI)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+5),A	;
					;
	LD	A,(LBA_TARGET_LO+1)	;
	AND	0FH			;
	LD	(DISPLAYBUF+2),A	;
	LD	A,(LBA_TARGET_LO+1)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+3),A	;
	
	LD	A,(LBA_TARGET_LO)	;
	AND	0FH			;
	LD	(DISPLAYBUF),A		;
	LD	A,(LBA_TARGET_LO)	;
	AND	0F0H			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	SRL	A			;
	LD	(DISPLAYBUF+1),A	;

SEGDISPLAY1:				;
	LD	HL,DISPLAYBUF		;
	LD	BC,0007H		;
	ADD	HL,BC			;
	LD	B,08H			; SET DIGIT COUNT
	LD	A,40H			; SET CONTROL PORT 7218 TO OFF
	OUT	(PORTC),A		; OUTPUT
	CALL 	DELAY12			; WAIT
	LD	A,0D0H			; SET CONTROL TO 1111 (DATA COMING, HEX DECODE, DECODE, NORMAL)
	OUT	(PORTA),A		; OUTPUT TO PORT
	LD	A,80H			; STROBE WRITE PULSE WITH CONTROL=1
	OUT	(PORTC),A		; OUTPUT TO PORT
	CALL 	DELAY12			; WAIT
	LD	A,40H			; SET CONTROL PORT 7218 TO OFF
	OUT	(PORTC),A		; OUTPUT
	CALL 	DELAY12			; WAIT
SEGDISPLAY_LP:		
	LD	A,(HL)			; GET DISPLAY DIGIT
	OUT	(PORTA),A		; OUT TO PORTA
	LD	A,00H			; SET WRITE STROBE
	OUT	(PORTC),A		; OUT TO PORTC
	CALL	DELAY12			; DELAY
	LD	A,40H			; SET CONTROL PORT OFF
	OUT	(PORTC),A		; OUT TO PORTC
	CALL	DELAY12			; WAIT
	DEC	HL			; INC POINTER
	DJNZ	SEGDISPLAY_LP		; LOOP FOR NEXT DIGIT
	RET	
	
DISPLAYBUF:	 .DB 	01,02,03,04,05,06,07,08
		 .DB	00,00,00,00,00,00,00,00	
		 .DB	00,00,00,00,00,00,00,00	
		 .DB	00,00,00,00,00,00,00,00	
		 .DB	00,00,00,00,00,00,00,00	
FLOPPYSTACK:	 .DB	00
PARKSTACK:	 .DB	00,00,00,00
		


CPMSTART	.DW	00			; START OF CP/M
DRIVE		.DB	0			; DRIVE
TRACK		.DB 	0			; TRACK
HEAD		.DB	0			; HEAD
SECTOR		.DB	0			; SECTOR
LBA_TARGET_LO:	.DW 	0			; IDE HD PARTITION TARGET SECTOR (LOW 16 BITS)
LBA_TARGET_HI:	.DW 	0			; IDE HD PARTITION TARGET SECTOR (HI 16 BITS, 12 USED)
IDEDEVICE:	.DB 	0			; ATAPI DEVICE SELECTION FLAG

IDE_LBA0:	.DB 	0			; SET LBA 0:7
IDE_LBA1:	.DB 	0			; SET LBA 8:15
IDE_LBA2:	.DB 	0			; SET LBA 16:23
IDE_LBA3:	.DB 	0			; LOWEST 4 BITS USED ONLY TO ENABLE LBA MODE 
;
SECTOR_BUFFER:	.DS 520				; STORAGE FOR 512 BYTE IDE HD SECTOR

		
	
	
	
	
;__HXOUT_________________________________________________________________________________________________________________________ 
;
;	PRINT THE ACCUMULATOR CONTENTS AS HEX DATA ON THE SERIAL PORT
;________________________________________________________________________________________________________________________________
;
HXOUT:
	PUSH	BC			; SAVE BC
	LD	B,A			;
	RLC	A			; DO HIGH NIBBLE FIRST  
	RLC	A			;
	RLC	A			;
	RLC	A			;
	AND	0FH			; ONLY THIS NOW
	ADD	A,30H			; TRY A NUMBER
	CP	3AH			; TEST IT
	JR	C,OUT1			; IF CY SET PRINT 'NUMBER'
	ADD	A,07H			; MAKE IT AN ALPHA
OUT1:
	CALL	COUT			; SCREEN IT
	LD	A,B			; NEXT NIBBLE
	AND	0FH			; JUST THIS
	ADD	A,30H			; TRY A NUMBER
	CP	3AH			; TEST IT
	JR	C,OUT2			; PRINT 'NUMBER'
	ADD	A,07H			; MAKE IT ALPHA
OUT2:
	CALL	COUT			; SCREEN IT
	POP	BC			; RESTORE BC
	RET				;


;__SPACE_________________________________________________________________________________________________________________________ 
;
;	PRINT A SPACE CHARACTER ON THE SERIAL PORT
;________________________________________________________________________________________________________________________________
;
SPACE:
	PUSH	AF			; Store AF
	LD	A,20H			; LOAD A "SPACE"
	CALL	COUT			; SCREEN IT
	POP	AF			; RESTORE AF
	RET				; DONE

;__CRLF_________________________________________________________________________________________________________________________ 
;
;	PRINT A cr/lf
;________________________________________________________________________________________________________________________________
;
CRLF:
	PUSH	AF			; Store AF
	LD	A,0DH			; LOAD A "SPACE"
	CALL	COUT			; SCREEN IT
	LD	A,0AH			; LOAD A "SPACE"
	CALL	COUT			; SCREEN IT
	POP	AF			; RESTORE AF
	RET				; DONE

;__COUT_________________________________________________________________________________________________________________________ 
;
;	PRINT CONTENTS OF A 
;________________________________________________________________________________________________________________________________
;
COUT:
	PUSH	BC			;
	PUSH	AF			;
	PUSH	HL			;
	PUSH	DE			;
		
	LD	(COUT_BUFFER),A		;
	LD	DE,COUT_BUFFER		;
	LD	C,09H			; CP/M WRITE START STRING TO CONSOLE CALL
	CALL	0005H
	POP	DE			;
	POP	HL			;
	POP	AF			;
	POP	BC			;
	RET				; DONE




;__PHL_________________________________________________________________________________________________________________________ 
;
;	PRINT THE HL REG ON THE SERIAL PORT
;________________________________________________________________________________________________________________________________
;
PHL:
	LD	A,H			; GET HI BYTE
	CALL	HXOUT			; DO HEX OUT ROUTINE
	LD	A,L			; GET LOW BYTE
	CALL	HXOUT			; HEX IT
	CALL	SPACE			; 
	RET				; DONE  

COUT_BUFFER:
	.DB	00
	.DB	"$"

	.end
	